/************************************************************************
 * NAME:	standard.c
 *
 * DESCR:	standard routines such as packing ints, etc.
 *
 * NOTES:	
 ************************************************************************/

#include "hdos.h"

/************************************************************************
 * NAME:	hdos_int_pack()
 *
 * DESCR:	Given an int, pack it into a 2-byte int in reverse order
 *		for HDOS.  The results are stored in the given buffer,
 *		which is assumed to have 2 slots for storage.
 *
 * ARGS:	
 *
 * RETURNS:	the target byte is returned
 *
 * NOTES:	
 ************************************************************************/

int
hdos_int_pack(int target, unsigned char *buffer)
{
    *buffer++ = target & 0x00ff;
    *buffer   = (target >> 8) & 0x00ff;

    return(target);
}

int
hdos_int_unpack(unsigned char *buffer)
{
    int	r = 0;

    r = *buffer++;
    r |= (*buffer << 8) & 0xff00;

    return(r);
}
